within Modelica.Magnetic.FluxTubes.Material;
package HysteresisEverettParameter "Parameter sets for an analytical description of the Everett function"
  extends Modelica.Icons.MaterialPropertiesPackage;

  annotation (Documentation(info="<html>
<p>These parameter records contain the parameters which adapt the analytical Everett function to a specific hysteresis shape (see <a href=\"modelica://Modelica.Magnetic.FluxTubes.UsersGuide.Literature\">[YUY89]</a> for a detailed description of that function). The Everett function is used to define the shape of the ferromagnetic hysteresis of the <code><a href=\"modelica://Modelica.Magnetic.FluxTubes.Shapes.HysteresisAndMagnets.GenericHystTellinenEverett\">GenericHystTellinenEverett</a></code> and the <code><a href=\"modelica://Modelica.Magnetic.FluxTubes.Shapes.HysteresisAndMagnets.GenericHystPreisachEverett\">GenericHystPreisachEverett</a></code> flux tube elements.</p>
</html>"));
end HysteresisEverettParameter;
